using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Reflection;
using System.Text;
using System.Threading;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
//using System.Runtime.Serialization;


namespace CSharpRecipes
{
	public class Collections
    {
        #region "5.1 Zamiana miejscami dwch elementw w tablicy"
        public static void TestSwapArrayElements()
        {
            int[] someArray = new int[5] { 1, 2, 3, 4, 5 };
            for (int counter = 0; counter < someArray.Length; counter++)
            {
                Console.WriteLine("Element " + counter + " = " + someArray[counter]);
            }
            SwapElementsInArray(someArray, 0, 4);

            for (int counter = 0; counter < someArray.Length; counter++)
            {
                Console.WriteLine("Element " + counter + " = " + someArray[counter]);
            }

     		Console.WriteLine();
 			object[] SomeObjArray = new object[5] {1,2,3,4,5};
			
			for (int counter = 0; counter < SomeObjArray.Length; counter++)
			{
				Console.WriteLine("Element " + counter + " = " + 
					SomeObjArray[counter]);
			}

			SwapElementsInArray(SomeObjArray, 0, someArray.Length-1);

			for (int counter = 0; counter < SomeObjArray.Length; counter++)
			{
				Console.WriteLine("Element " + counter + " = " + 
					SomeObjArray[counter]);
			}
		}
		
		public unsafe static void SwapElementsInArray(int[] theArray, int index1, int index2)
		{
			if (theArray.Length > 0)
			{
				if (index1 >= theArray.Length || index2 >= theArray.Length || index1 < 0 || index2 < 0)
				{
                    Console.WriteLine("indeks przekazany do tej metody jest poza zakresem");
				}
				else
				{
					fixed (int* PtrToSomeArray = theArray)
					{
						int tempHolder = theArray[index1];
						theArray[index1] = theArray[index2];
						theArray[index2] = tempHolder;
					}
				}
			}
			else
			{
				Console.WriteLine("Nie ma nic do odwracania");
			}
		}
		
		public static void SwapElementsInArray<T>(T[] theArray, int index1, int index2)
		{
			if (theArray.Length > 0)
			{
				if (index1 >= theArray.Length || index2 >= theArray.Length || index1 < 0 || index2 < 0)
				{
                    Console.WriteLine("indeks przekazany do tej metody jest poza zakresem.");
				}
				else
				{
					T tempHolder = theArray[index1];
					theArray[index1] = theArray[index2];
					theArray[index2] = tempHolder;
				}
			}
			else
			{
				Console.WriteLine("Nie ma nic do odwracania");
			}
		}
		#endregion

        #region "5.2 Szybkie odwracanie tablicy"
        public unsafe static void TestArrayReversal()
		{
			int[] someArray = new int[5] {1,2,3,4,5};

			for (int counter = 0; counter < someArray.Length; counter++)
			{
				Console.WriteLine("Element " + counter + " = " + someArray[counter]);
			}

			DoReversal(someArray);

			for (int counter = 0; counter < someArray.Length; counter++)
			{
				Console.WriteLine("Element " + counter + " = " + someArray[counter]);
			}
			
			Array.Reverse(someArray);

			for (int counter = 0; counter < someArray.Length; counter++)
			{
				Console.WriteLine("Element " + counter + " = " + someArray[counter]);
			}
		}

//		public unsafe static void DoReversal(int[] theArray)
//		{
//			int tempHolder = 0;
//
//			if (theArray.Length > 0)
//			{
//				fixed (int* PtrToArray = theArray)
//				{
//					for (int counter = 0; counter < (theArray.Length / 2); counter++)
//					{
//						tempHolder = PtrToArray[counter];                        
//						PtrToArray[counter] = theArray[theArray.Length - counter - 1];   
//						PtrToArray[theArray.Length - counter - 1] = tempHolder;      
//					}
//				}
//			}
//			else
//			{
//				Console.WriteLine("Nie ma nic do odwracania");
//			}
//		}

		public static void DoReversal<T>(T[] theArray)
		{
			T tempHolder = default(T);

			if (theArray.Length > 0)
			{
				for (int counter = 0; counter < (theArray.Length / 2); counter++)
				{
					tempHolder = theArray[counter];                        
					theArray[counter] = theArray[theArray.Length - counter - 1];   
					theArray[theArray.Length - counter - 1] = tempHolder;      
				}
			}
			else
			{
				Console.WriteLine("Nie ma nic do odwracania");
			}
		}
        #endregion

        #region "5.3 Odwracanie tablic wielowymiarowych"
        public static void TestReverse2DimArray()
		{
			int[,] someArray = new int[5,3] {{1,2,3},{4,5,6},{7,8,9},{10,11,12},{13,14,15}};

			foreach (int i in someArray)
			{
				Console.WriteLine(i);
			}

			Console.WriteLine();
			Reverse2DimArray(someArray);

			foreach (int i in someArray)
			{
				Console.WriteLine(i);
			}
		}
		
		public static void Reverse2DimArray<T>(T[,] theArray)
		{
			for (int rowIndex = 0; rowIndex <= (theArray.GetUpperBound(0)); rowIndex++)
			{
				for (int colIndex = 0; colIndex <= (theArray.GetUpperBound(1) / 2); colIndex++)
				{
					T tempHolder = theArray[rowIndex, colIndex];                        
					theArray[rowIndex, colIndex] = theArray[rowIndex, theArray.GetUpperBound(1) - colIndex];   
					theArray[rowIndex, theArray.GetUpperBound(1) - colIndex] = tempHolder;      
				}
			}
		}
		#endregion

        #region "5.4 Odwracanie tablic postrzpionych"
        public static void TestReverseJaggedArray()
		{
			int[][] someArray = new int[][] {new int[3] {1,2,3}, new int[6]{10,11,12,13,14,15}};

			for (int rowIndex = 0; rowIndex < someArray.Length; rowIndex++)
			{
				for (int colIndex = 0; colIndex < someArray[rowIndex].Length; colIndex++)
				{
					Console.WriteLine(someArray[rowIndex][colIndex]);
				}
			}

			Console.WriteLine();
			ReverseJaggedArray(someArray);

			for (int rowIndex = 0; rowIndex < someArray.Length; rowIndex++)
			{
				for (int colIndex = 0; colIndex < someArray[rowIndex].Length; colIndex++)
				{
					Console.WriteLine(someArray[rowIndex][colIndex]);
				}
			}
		}
		
		public static void ReverseJaggedArray<T>(T[][] theArray)
		{
			for (int rowIndex = 0; rowIndex <= (theArray.GetUpperBound(0)); rowIndex++)
			{
				for (int colIndex = 0; colIndex <= (theArray[rowIndex].GetUpperBound(0) / 2); colIndex++)
				{
					T tempHolder = theArray[rowIndex][colIndex];                        
					theArray[rowIndex][colIndex] = theArray[rowIndex][theArray[rowIndex].GetUpperBound(0) - colIndex];   
					theArray[rowIndex][theArray[rowIndex].GetUpperBound(0) - colIndex] = tempHolder;      
				}
			}
		}
		#endregion
		
		#region "5.5 Bardziej uniwersalna klasa StackTrace"
		public static void TestStackTraceArray()
		{
			StackTraceArray arrStackTrace = new StackTraceArray();
			Console.WriteLine("ToString:" + arrStackTrace.ToString());

			for (int i = 0; i < arrStackTrace.Count; i++)
				Console.WriteLine(arrStackTrace.GetFrameAsString(i));

			Console.WriteLine("\r\nCount:       " + arrStackTrace.Count);
			Console.WriteLine("Contains:    " + arrStackTrace.Contains(new StackFrame()));
			Console.WriteLine("Contains:    " + arrStackTrace.Contains(arrStackTrace[1]));
			Console.WriteLine("FrameCount:  " + arrStackTrace.FrameCount);
			Console.WriteLine("hash:        " + arrStackTrace.GetHashCode());
			Console.WriteLine("GetType:     " + arrStackTrace.GetType().ToString());
			Console.WriteLine("IsFixedSize: " + arrStackTrace.IsFixedSize);
			Console.WriteLine("IsReadOnly:  " + arrStackTrace.IsReadOnly);
			Console.WriteLine("IsSynch:     " + arrStackTrace.IsSynchronized);
			Console.WriteLine("GetFrame(0): " + arrStackTrace.GetFrame(0).ToString());
			Console.WriteLine("GetFrame(1): " + arrStackTrace.GetFrame(1).ToString());
			Console.WriteLine("GetFrame(2): " + arrStackTrace.GetFrame(2).ToString());
			Console.WriteLine("IndexOf:     " + arrStackTrace.IndexOf(arrStackTrace.GetFrame(1)));

			//Console.WriteLine("\r\nSyncRoot: " + ((StackFrame[])arrStackTrace.SyncRoot).Length);
			
			// Intentionally throws exceptions 
			//arrStackTrace.Add(new StackFrame());
			//arrStackTrace.Insert(0, new StackFrame());
			//arrStackTrace.Remove(new StackFrame());
			//arrStackTrace.RemoveAt(1);

			Console.WriteLine("\r\n\r\nstackframe[]: " + arrStackTrace[0].ToString());
			foreach (StackFrame sf in arrStackTrace)
			{
				Console.WriteLine("stackframe: " + sf.ToString());
			}
			
			//arrStackTrace[0] = new StackFrame("FILE", 100, 100);
			//arrStackTrace[1] = arrStackTrace[0];
			foreach (StackFrame sf in arrStackTrace)
			{
				Console.WriteLine("sf: " + sf.ToString());
			}
			
			StackTraceArray temp = arrStackTrace;
			Console.WriteLine("Equals: " + arrStackTrace.Equals(temp));

			foreach (StackFrame sf in temp)
			{
				Console.WriteLine("temp [before]: " + sf.ToString());
			}
			//temp.Clear();
			foreach (StackFrame sf in temp)
			{
				if (sf == null)
					Console.WriteLine("temp [after]:  null");
				else
					Console.WriteLine("temp [after]:  " + sf.ToString());
			}
			
			StackFrame[] MyNewArray = new StackFrame[arrStackTrace.Count];
			arrStackTrace.CopyTo(MyNewArray, 0);
			Console.WriteLine("\r\nMyNewArray.Length: " + MyNewArray.Length);
			
			
			Console.WriteLine("\r\n\r\n");
			try{ throw (new Exception("TEST")); }
			catch (Exception e)
			{
				StackTraceArray EST = new StackTraceArray(e, true);
				
				Console.WriteLine("TOSTRING: \r\n" + EST.ToString());
				foreach (StackFrame sf in EST)
				{
					if (sf == null)
						Console.WriteLine("NULL");
					else
						Console.WriteLine(sf.ToString());
				}				

				StackTraceArray EST2 = new StackTraceArray(System.Threading.Thread.CurrentThread, false);
				
				Console.WriteLine("TOSTRING: \r\n" + EST2.ToString());
				foreach (StackFrame sf in EST2)
				{
					if (sf == null)
						Console.WriteLine("NULL");
					else
						Console.WriteLine(sf.ToString());
				}				

				try{ throw (new Exception("TESTINTERNAL", e)); }
				catch (Exception eInner)
				{
					StackTraceArray ESTInner = new StackTraceArray(eInner, true);
				
					Console.WriteLine("TOSTRING: " + Environment.NewLine + eInner.ToString());
					Console.WriteLine("TOSTRING: " + Environment.NewLine + ESTInner.ToString());
					
					foreach (StackFrame sf in ESTInner)
					{
						if (sf == null)
							Console.WriteLine("NULL");
						else
							Console.WriteLine(sf.ToString());
					}
				}
			}
		}
 
 
		public class StackTraceArray : StackTrace, IList  // ICollection, IEnumerable derive from IList
		{
			public StackTraceArray() : base() 
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(bool needFileInfo) : base(needFileInfo)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(Exception e) : base(e)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(int skipFrames) : base(skipFrames)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(StackFrame frame) : base(frame)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(Exception e, bool needFileInfo) : base(e, needFileInfo)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(Exception e, int skipFrames) : base(e, skipFrames)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(int skipFrames, bool needFileInfo) : 
				base(skipFrames, needFileInfo)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(Thread targetThread, bool needFileInfo) : 
				base(targetThread, needFileInfo)
			{
				InitInternalFrameArray();
			}

			public StackTraceArray(Exception e, int skipFrames, bool needFileInfo) : 
				base(e, skipFrames, needFileInfo)
			{
				InitInternalFrameArray();
			}


			private StackFrame[] internalFrameArray = null;


			private void InitInternalFrameArray()
			{
				internalFrameArray = new StackFrame[this.FrameCount];

				for (int counter = 0; counter < base.FrameCount; counter++)
				{
					internalFrameArray[counter] = base.GetFrame(counter);
				}
			}

			public string GetFrameAsString(int index)
			{
				StringBuilder str = new StringBuilder("\tat ");
				str.Append(GetFrame(index).GetMethod().DeclaringType.FullName);
				str.Append(".");
				str.Append(GetFrame(index).GetMethod().Name);
				str.Append("(");
				foreach (ParameterInfo PI in GetFrame(index).GetMethod().GetParameters())
				{
					str.Append(PI.ParameterType.Name);
					if (PI.Position < (GetFrame(index).GetMethod().GetParameters().Length - 1))
					{
						str.Append(", ");
					}
				}
				str.Append(")");

				return (str.ToString());
			}

            // Waciwoci/metody interfejsu IList
			public bool IsFixedSize 
			{
				get {return (internalFrameArray.IsFixedSize);}
			}

			public bool IsReadOnly 
			{
				get {return (true);}
			}

			public object this[int index] 
			{
				get {return (internalFrameArray[index]);}
				set {throw (new NotSupportedException("Dla tego obiektu metoda indeksatora set nie jest obsugiwana."));}
			}

			public int Add(object value)
			{
				return (((IList)internalFrameArray).Add(value));
			}

			public void Insert(int index, object value)
			{
				((IList)internalFrameArray).Insert(index, value);
			}

			public void Remove(object value)
			{
				((IList)internalFrameArray).Remove(value);
			}

			public void RemoveAt(int index)
			{
				((IList)internalFrameArray).RemoveAt(index);
			}

			public void Clear()
			{
                //  Zgoszenie wyjtku w celu zapobieenia utraty danych.
                throw (new NotSupportedException("Metoda Clear nie jest obsugiwana dla tego obiektu."));
			}

			public bool Contains(object value)
			{
				return (((IList)internalFrameArray).Contains(value));
			}

			public int IndexOf(object value)
			{
				return (((IList)internalFrameArray).IndexOf(value));
			}

            // Metoda interfejsu IEnumerable
			public IEnumerator GetEnumerator()
			{
				return (internalFrameArray.GetEnumerator());
			}

            //  Metody/waciwoci interfejsu ICollection
			public int Count 
			{
				get {return (internalFrameArray.Length);}
			}

			public bool IsSynchronized 
			{
				get {return (internalFrameArray.IsSynchronized);}
			}

			public object SyncRoot 
			{
				get {return (internalFrameArray.SyncRoot);}
			}

			public void CopyTo(Array array, int index)
			{
				internalFrameArray.CopyTo(array, index);
			}
		}
		#endregion

        #region "5.6 Okrelanie liczby wystpie elementu na licie List<T>"
        public static void TestArrayListEx()
		{
			ListEx<int> arrayExt = new ListEx<int>();
			arrayExt.Add(-2);
			arrayExt.Add(-2);
			arrayExt.Add(-1);
			arrayExt.Add(-1);
			arrayExt.Add(1);
			arrayExt.Add(2);		
			arrayExt.Add(2);
			arrayExt.Add(2);
			arrayExt.Add(2);		
			arrayExt.Add(3);
			arrayExt.Add(100);
			arrayExt.Add(4);
			arrayExt.Add(5);

			Console.WriteLine("--ZAWIERA OGӣEM--");
			int Count = arrayExt.CountAll(2);
			Console.WriteLine("Count2: " + Count);

			Count = arrayExt.CountAll(3);
			Console.WriteLine("Count3: " + Count);

			Count = arrayExt.CountAll(1);
			Console.WriteLine("Count1: " + Count);

            Console.WriteLine("\r\n--BINARNE WYSZUKIWANIE WSZYSTKICH WYSTPIE--");
			Count = arrayExt.BinarySearchCountAll(2);
			Console.WriteLine("Count2: " + Count);

			Count = arrayExt.BinarySearchCountAll(3);
			Console.WriteLine("Count3: " + Count);

			Count = arrayExt.BinarySearchCountAll(1);
			Console.WriteLine("Count1: " + Count);
		}


        public class ListEx<T> : List<T>
        {
            // Zliczanie liczby wystpie elementu na
            // nieposortowanej bd posortowanej licie List<T>
            public int CountAll(T searchValue)
            {
                int foundCounter = 0;
                for (int index = 0; index < this.Count; index++)
                {
                    if (this[index].Equals(searchValue))
                    {
                        foundCounter++;
                    }
                }
                return (foundCounter);
            }

    // Zliczanie liczby wystpie elementu na posortowanej licie List<T>
    public int BinarySearchCountAll(T searchValue)
    {
				// Sortowanie listy List<T>
				this.Sort();

				bool done = false;
				int count = 0;

				// Wyszukiwanie pierwszego elementu
				int center = this.BinarySearch(searchValue);
				int left = center - 1;
				int right = center + 1;
				int position = -1;

				if (center >= 0)
				{
					// Inkrementacja licznika dla znalezionego elementu
					++count;

					// Wyszukiwanie w lewo
					do
					{
						if (left < 0)
						{
							done = true;
						}
						else
						{
							if (this[left].Equals(searchValue))
							{
								position = left;
							}
							else
							{
								position = -1;
							}

							if (position < 0)
							{
								done = true;
							}
							else
							{
								// Inkrementacja licznika dla znalezionego elementu
								++count;
							}
						}

						--left;
					}while (!done);

					// Reset flagi done
					done = false;

					// Wyszukiwanie w prawo
					do
					{
						if (right >= (this.Count))
						{
							done = true;
						}
						else
						{
							if (this[right].Equals(searchValue))
							{
								position = right;
							}
							else
							{
								position = -1;
							}

							if (position < 0)
							{
								done = true;
							}
							else
							{
								// Inkrementacja licznika dla znalezionego elementu
								++count;
							}
						}

						++right;
					}while (!done);
				}

				return (count);
			}
		
		
		
			// Metoda pobierajca wszystkie pasujce obiekty na 
			//  posortowanej i nieposortowanej licie ListEx<T>
			public T[] GetAll(T searchValue)
			{
				List<T> foundItem = new List<T>();

				for (int index = 0; index < this.Count; index++)
				{
					if (this[index].Equals(searchValue))
					{
						foundItem.Add(this[index]);
					} 
				}

				return (foundItem.ToArray());
			}

			// Metoda pobierajca wszystkie pasujce obiekty na posortowanej licie ListEx<T>
			public T[] BinarySearchAll(T searchValue)
			{
				// Posortowanie listy List<T>
				this.Sort();

				bool done = false;
				List<T> RetObjs = new List<T>();

				// Wyszukiwanie pierwszego elementu
				int center = this.BinarySearch(searchValue);
				int left = center - 1;
				int right = center + 1;
				int position = -1;

				if (center >= 0)
				{
					// Dodanie pierwszego znalezionego elementu
					RetObjs.Add(this[center]);

					// Wyszukiwanie do lewej
					do
					{
						if (left < 0)
						{
							done = true;
						}
						else
						{
							if (this[left].Equals(searchValue))
							{
								position = left;
							}
							else
							{
								position = -1;
							}

							if (position < 0)
							{
								done = true;
							}
							else
							{
								// Dodanie nastpnego znalezionego elementu do lewej
								RetObjs.Add(this[left]);
							}
						}

						--left;
					}while (!done);

					// Reset flagi done
					done = false;

					// Wyszukiwanie do prawej
					do
					{
						if (right >= (this.Count))
						{
							done = true;
						}
						else
						{
							if (this[right].Equals(searchValue))
							{
								position = right;
							}
							else
							{
								position = -1;
							}

							if (position < 0)
							{
								done = true;
							}
							else
							{
								// Dodanie nastpnego znalezionego elementu do prawej
								RetObjs.Add(this[right]);
							}
						}

						++right;
					}while (!done);
				}

				return (RetObjs.ToArray());
			}
		}
		#endregion

        #region "5.7 Wyodrbnianie wszystkich egzemplarzy okrelonego elementu z listy List<T>"
        public static void TestArrayListEx2()
		{
			ListEx<int> arrayExt = new ListEx<int>();
			arrayExt.Add(-1);
			arrayExt.Add(-1);
			arrayExt.Add(1);
			arrayExt.Add(2);		
			arrayExt.Add(2);
			arrayExt.Add(2);
			arrayExt.Add(2);		
			arrayExt.Add(3);
			arrayExt.Add(100);
			arrayExt.Add(4);
			arrayExt.Add(5);

            Console.WriteLine("--POBRANIE WSZYSTKICH OBIEKTW--");
			int[] objects = arrayExt.GetAll(2);
			foreach (object o in objects)
			{
				Console.WriteLine("obj2: " + o);
			}

			Console.WriteLine();
			objects = arrayExt.GetAll(-2);
			foreach (object o in objects)
			{
				Console.WriteLine("obj-2: " + o);
			}

			Console.WriteLine();
			objects = arrayExt.GetAll(5);
			foreach (object o in objects)
			{
				Console.WriteLine("obj5: " + o);
			}

            Console.WriteLine("\r\n--POBRANIE WSZYSTKICH OBIEKTW Z WYKORZYSTANIEM WYSZUKIWANIA BINARNEGO--");
			objects = arrayExt.BinarySearchAll(-2);
			foreach (object o in objects)
			{
				Console.WriteLine("obj-2: " + o);
			}

			Console.WriteLine();
			objects = arrayExt.BinarySearchAll(2);
			foreach (object o in objects)
			{
				Console.WriteLine("obj2: " + o);
			}

			Console.WriteLine();
			objects = arrayExt.BinarySearchAll(5);
			foreach (object o in objects)
			{
				Console.WriteLine("obj5: " + o);
			}
		}
        #endregion		
		
        #region "5.8 Wstawianie i usuwanie elementw z tablicy"
        public static void TestArrayInsertRemove()
		{
			string[] numbers = {"jeden", "dwa", "cztery", "pi", "sze"} ;

			InsertIntoArray(numbers, "trzy", 2);
			foreach (string number in numbers)
			{
				Console.WriteLine(number);
			}

	        Console.WriteLine();
	        RemoveFromArray(numbers, 2);
			foreach (string number in numbers)
			{
				Console.WriteLine(number);
			}
		}
		
		public static void InsertIntoArray(Array target, object value, int index)
		{
			if (index < target.GetLowerBound(0) || index > target.GetUpperBound(0))
			{
				throw (new ArgumentOutOfRangeException("index", index,
                    "Indeks tablicy poza zakresem."));
			}
			else if (index == target.GetLowerBound(0))
			{
				Array.Copy(target, index, target, index + 1, 
					target.Length - index - 1);
			}
			else
			{
				Array.Copy(target, index, target, index + 1, 
					target.Length - index - 1);
			}

			target.SetValue(value, index);
		}

		public static void RemoveFromArray(Array target, int index)
		{
			if (index < target.GetLowerBound(0) || index > target.GetUpperBound(0))
			{
				throw (new ArgumentOutOfRangeException("index", index, 
					"Indeks tablicy poza zakresem."));
			}
			else if (index < target.GetUpperBound(0))
			{
				Array.Copy(target, index + 1, target, index, 
					target.Length - index - 1);
			}

			target.SetValue(null, target.GetUpperBound(0));
		}
        #endregion

        #region "5.9 Utrzymywanie listy List<T> w stanie posortowanym"
        public static void TestSortedList()
		{
            // Utworzenie listy SortedList i wypenienie jej
            // losowymi liczbami.
			SortedList<int> SortedAL = new SortedList<int>();
			SortedAL.AddSorted(200);
			SortedAL.AddSorted(20);
			SortedAL.AddSorted(2);
			SortedAL.AddSorted(7);
			SortedAL.AddSorted(10);
			SortedAL.AddSorted(0);
			SortedAL.AddSorted(100);
			SortedAL.AddSorted(-20);
			SortedAL.AddSorted(56);
			SortedAL.AddSorted(55);
			SortedAL.AddSorted(57);
			SortedAL.AddSorted(200);
			SortedAL.AddSorted(-2);
			SortedAL.AddSorted(-20);
			SortedAL.AddSorted(55);
			SortedAL.AddSorted(55);

            // Wywietlenie elementw listy.
			foreach (int i in SortedAL)
			{
				Console.WriteLine(i);
			}

            // Modyfikacja wartoci pod okrelonym indeksem.
			SortedAL.ModifySorted(0, 5);
			SortedAL.ModifySorted(1, 10);
			SortedAL.ModifySorted(2, 11);
			SortedAL.ModifySorted(3, 7);
			SortedAL.ModifySorted(4, 2);
			SortedAL.ModifySorted(2, 4);
			SortedAL.ModifySorted(15, 0);
			SortedAL.ModifySorted(0, 15);
			SortedAL.ModifySorted(223, 15);

            // Wywietlenie elementw listy.
			Console.WriteLine();
			foreach (int i in SortedAL)
			{
				Console.WriteLine(i);
			}
			
			// Zastosowanie trudniejszego sposobu
			List<int> Test = new List<int>();
			Test.Add(200);
			Test.Sort();
			Test.Add(20);
			Test.Sort();
			Test.Add(2);
			Test.Sort();
			Test.Add(7);
			Test.Sort();
			Test.Add(10);
			Test.Sort();
			Test.Add(0);
			Test.Sort();
			Test.Add(100);
			Test.Sort();
			Test.Add(-20);
			Test.Sort();
			Test.Add(56);
			Test.Sort();
			Test.Add(55);
			Test.Sort();
			Test.Add(57);
			Test.Sort();
			Test.Add(200);
			Test.Sort();
		}
/*  ORYGINALNE DANE
-20
-20
-2
0
2
7
10
20
55
55
55
56
57
100
200
200
 
-20
0
0
0
2
2
3
4
10
15
20
55
55
57
100
223
*/

		public class SortedList<T> : List<T>
		{
			public void AddSorted(T item)
			{
				int position = this.BinarySearch(item);
				if (position < 0)
				{
					position = ~position;
				}

				this.Insert(position, item);
			}

			public void ModifySorted(T item, int index)
			{
				this.RemoveAt(index);

				int position = this.BinarySearch(item);
				if (position < 0)
				{
					position = ~position;
				}

				this.Insert(position, item);
			}
		}
		#endregion

        #region "5.10 Sortowanie indeksw i (lub) wartoci obiektu klasy Dictionary"
        public static void TestSortKeyValues()
        {
            // Definicja obiektu Dictionary<T,U>.
			Dictionary<string, string> hash = new Dictionary<string, string>();
//			hash.Add(2, "dwa");
//			hash.Add(1, "jeden");
//			hash.Add(5, "pi");
//			hash.Add(4, "cztery");
//			hash.Add(3, "trzy");
            hash.Add("2", "dwa");
            hash.Add("1", "jeden");
            hash.Add("5", "pi");
            hash.Add("4", "cztery");
            hash.Add("3", "trzy");

            // Pobranie wszystkich indeksw z obiektu Dictionary<T,U> i posortowanie ich.
			List<string> keys = GetKeys(hash);
			keys.Sort();
			foreach (string obj in keys)
				Console.WriteLine("Indeks: " + obj + "    Warto: " + hash[obj]);

            // Odwrcenie posortowanej listy.
			Console.WriteLine();
			keys.Reverse();
			foreach (string obj in keys)
				Console.WriteLine("Indeks: " + obj + "    Warto: " + hash[obj]);

            //  Pobranie wszystkich wartoci z obiektu Dictionary<T,U> i posortowanie ich.
			Console.WriteLine();
			Console.WriteLine();
			List<string> values = GetValues(hash);
			values.Sort();
			foreach (string obj in values)
				Console.WriteLine("Warto: " + obj);

            // Odwrcenie posortowanej listy wartoci.
			Console.WriteLine();
			values.Reverse();
			foreach (string obj in values)
				Console.WriteLine("Warto: " + obj);
		}
		
		public static List<T> GetKeys<T,U>(Dictionary<T,U> table)
		{
			return (new List<T>(table.Keys));
		}
		
		public static List<U> GetValues<T,U>(Dictionary<T,U> table)
		{
			return (new List<U>(table.Values));
		}
		#endregion

        #region "5.11 Tworzenie obiektu Dictionary z ograniczeniami dla wartoci minimalnej i maksymalnej"
        public static void TestMaxMinSizeDict()
		{
			MaxMinSizeDictionary<int, int> table = new MaxMinSizeDictionary<int, int>(2, 4);
			table.Add(1,100);
			table.Add(2,200);
			table.Add(3,150);
			table.Add(4,200);
			table[2] = 100;

			Console.WriteLine();
			foreach (KeyValuePair<int,int> kvp in table)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);
			
			table.Remove(1);
			table.Remove(2);
			//Table.Remove(3);

			Console.WriteLine();
			foreach (KeyValuePair<int, int> kvp in table)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);

			//Table.Clear();
			
			
			MaxMinSizeDictionary<int, int> EHT2 = new MaxMinSizeDictionary<int, int>();
			EHT2.Add(1,int.MinValue);
			EHT2.Remove(1);

			Console.WriteLine();
			foreach (KeyValuePair<int, int> kvp in EHT2)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);

			//EHT2.ReadOnly = true;
			
			EHT2.Add(1,int.MinValue);
			EHT2.Add(2,int.MaxValue);
			EHT2.Add(3,150);
			EHT2.Add(4,-200);
			EHT2.Add(5,200);
			EHT2.Add(6,20);
			EHT2.Add(7,2000);
			EHT2.Add(8,2000);
			EHT2.Add(9,2000);
			EHT2.Add(10,2000);
			//EHT2.Add(11,2000);

			Console.WriteLine();
			foreach (KeyValuePair<int, int> kvp in EHT2)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);

			EHT2.Remove(2);
			EHT2.Remove(3);

			Console.WriteLine();
			foreach (KeyValuePair<int, int> kvp in EHT2)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);

			EHT2.Clear();
		}
			

		[Serializable]
		public class MaxMinSizeDictionary<T,U> : Dictionary<T,U>
		{
			public MaxMinSizeDictionary() : base(10) {}

			public MaxMinSizeDictionary(int minSize, int maxSize) 
				: base(maxSize)
			{
				if (minSize >= 0 && maxSize > 0)
				{
					this.minSize = minSize;
					this.maxSize = maxSize;
				}
			}


			protected int minSize = 0;
			protected int maxSize = 10;       // Pocztkowy rozmiar dla standardowej tablicy Hashtable
			protected bool readOnly = false;


			public bool ReadOnly 
			{
				get {return (readOnly);}
				set {readOnly = value;}
			}


			public new U this[T key] 
			{
				get 
				{
					return (base[key]);
				}
				set 
				{
					if (!readOnly)
					{
						if (key is long)
						{
							if (long.Parse(key.ToString()) < maxSize && long.Parse(key.ToString()) > minSize)
							{
								base[key] = value;
							}
							else
							{
								throw (new ArgumentOutOfRangeException("key", key, 
									"Indeks znajduje si poza zakresem pomidzy wartoci minimaln, a maksymaln."));
							}
						}
						else
						{
							base[key] = value;
						}
					}
					else
					{
						throw (new ArgumentOutOfRangeException("value", value, 
							"Ta tablica Hashtable jest ustawiona na warto tylko do odczytu."));
					}
				}
			}

			public new void Add(T key, U value)
			{
				if (!readOnly)
				{
					if (this.Count < maxSize)
					{
						base.Add(key, value);
					}
					else
					{
						throw (new ArgumentOutOfRangeException("value", value,
							"Nie mona doda wicej wartoci do tej tablicy Hashtable do czasu, gdy jaki nie zostanie usunty."));
					}
				}
				else
				{
					throw (new ArgumentOutOfRangeException("value", value, 
						"Ta tablica Hashtable jest obecnie ustawiona w tryb tylko do odczytu."));
				}
			}

			public new bool Remove(T key)
			{
				if (!readOnly)
				{
					if (this.Count > minSize)
					{
						base.Remove(key);
						return (true);
					}
					else
					{
						throw (new InvalidOperationException(
							"Z tej tablicy Hashtable nie mona usun wicej wartoci do czasu, gdy jaki nie zostanie dodany."));
					}
				}
				else
				{
					throw (new NotSupportedException(
						"Ta tablica Hashtable jest obecnie ustawiona w trybie tylko do odczytu."));
				}
			}

			public new void Clear()
			{
				if (!readOnly)
				{
					if (minSize == 0)
					{
						base.Clear();
					}
					else
					{
						throw (new InvalidOperationException(
							"Wyzerowanie tablicy Hashtable spowodowaoby przekroczenie minimalnego rozmiaru dla " + minSize));
					}
				}
				else
				{
					throw (new InvalidOperationException(
						"Ta tablica Hashtable jest obecnie ustawiona w tryb tylko do odczytu."));
				}
			}
		}
        #endregion
		
        #region "5.12 Tworzenie obiektu Hashtable z ograniczeniami dla wartoci maksymalnej i minimalnej"
		public static void TestMaxMinValueHash()
		{
			MaxMinValueHashtable Table = new MaxMinValueHashtable(100, 200);
			Table.Add(1,100);
			Table.Add(2,200);
			Table.Add(3,150);
			Table.Add(4,200);
			Table[2] = 100;
			//Table[2] = 500;
			Table.Add(5,200);
			//Table.Add(6,20);
			//Table.Add(7,2000);

			Console.WriteLine();
			foreach (DictionaryEntry o in Table)
				Console.WriteLine(o.Key + " : " + o.Value);
			
			Table.Remove(1);
			Table.Remove(2);
			Table.Remove(3);

			Console.WriteLine();
			foreach (DictionaryEntry o in Table)
				Console.WriteLine(o.Key + " : " + o.Value);

			Table.Clear();
			
			
			MaxMinValueHashtable EHT2 = new MaxMinValueHashtable();
			EHT2.Add(1,int.MinValue);
			EHT2.Remove(1);

			Console.WriteLine();
			foreach (DictionaryEntry o in EHT2)
				Console.WriteLine(o.Key + " : " + o.Value);

			//EHT2.ReadOnly = true;
			
			EHT2.Add(1,int.MinValue);
			EHT2.Add(2,int.MaxValue);
			EHT2.Add(3,150);
			EHT2.Add(4,-200);
			EHT2.Add(5,200);
			EHT2.Add(6,20);
			EHT2.Add(7,2000);

			Console.WriteLine();
			foreach (DictionaryEntry o in EHT2)
				Console.WriteLine(o.Key + " : " + o.Value);

			EHT2.Remove(2);
			EHT2.Remove(3);

			Console.WriteLine();
			foreach (DictionaryEntry o in EHT2)
				Console.WriteLine(o.Key + " : " + o.Value);

			EHT2.Clear();
		}

		[Serializable]
		public class MaxMinValueHashtable : Hashtable
		{
			public MaxMinValueHashtable() : base() {}

			public MaxMinValueHashtable(int minValue, int maxValue) 
				: base()
			{
				this.minValue = minValue;
				this.maxValue = maxValue;
			}


			protected int minValue = int.MinValue;
			protected int maxValue = int.MaxValue;
			protected bool readOnly = false;


			public bool ReadOnly 
			{
				get {return (readOnly);}
				set {readOnly = value;}
			}

			public override bool IsReadOnly
			{
				get	{return readOnly;}
			}


			public override object this[object key] 
			{
				get 
				{
					return (base[key]);
				}
				set 
				{
					if (!readOnly)
					{
						if (value is int)
						{
							if ((int)value >= minValue && (int)value <= maxValue)
							{
								base[key] = value;
							}
							else
							{
								throw (new ArgumentOutOfRangeException("value", value, 
									"Warto musi znajdowa si w dozwolonym zakresie " + minValue + " to " + maxValue));
							}
						}
						else
						{
							base[key] = value;
						}
					}
					else
					{
						throw (new ArgumentOutOfRangeException("value", value, 
							"Ten obiekt Hashtable jest ustawiony w tryb tylko do odczytu."));
					}
				}
			}

			public override void Add(object key, object value)
			{
				if (!readOnly)
				{
					base.Add(key, value);
				}
				else
				{
					throw (new ArgumentOutOfRangeException("value", value, 
						"Ten obiekt Hashtable jest ustawiony w tryb tylko do odczytu."));
				}
			}

			public void Add(object key, int value)
			{
				if (!readOnly)
				{
					if (value >= minValue && value <= maxValue)
					{
						base.Add(key, value);
					}
					else
					{
						throw (new ArgumentOutOfRangeException("value", value, 
							"Warto musi mieci si w zakresie od " + minValue + " do " + maxValue));
					}
				}
				else
				{
					throw (new ArgumentOutOfRangeException("value", value, 
						"Ten obiekt Hashtable jest ustawiony w trybie tylko do odczytu."));
				}
			}

			public override void Remove(object key)
			{
				if (!readOnly)
				{
					base.Remove(key);
				}
				else
				{
					throw (new ArgumentOutOfRangeException(
						"Ten obiekt Hashtable jest ustawiony w trybie tylko do odczytu."));
				}
			}

			public override void Clear()
			{
				if (!readOnly)
				{
					base.Clear();
				}
				else
				{
					throw (new ArgumentOutOfRangeException(
                        "Ten obiekt Hashtable jest ustawiony w trybie tylko do odczytu."));
				}
			}
		}
		#endregion

        #region "5.13 Wywietlanie danych z tablicy w postaci cigu znakw rozdzielanego separatorem"
        public static void TestDisplayDataAsDelStr()
		{
			string[] Numbers = {"jeden", "dwa", "trzy", "cztery", "pi", "sze"} ;
			
			string DelimitedStr = ConvertCollectionToDelStr(Numbers, ',');
			Console.WriteLine(DelimitedStr);
		}
		
		public static string ConvertArrayToDelStr(Array theArray, string delimiter)
		{
			string delimitedData = "";
			
			for (int index = 0; index < theArray.Length; index++)
			{
				if (theArray.GetValue(index).ToString().Equals(delimiter.ToString()))
				{
                    throw (new ArgumentException("Znak separatora nie moe wchodzi w skad elementu tablicy.", "delimiter"));
				}

				delimitedData += theArray.GetValue(index);
				
				// Dodanie cigu separatora, chyba e indeks wskazuje ostatni element w tablicy
				if (index < (theArray.Length - 1))
				{
					delimitedData += delimiter;
				}
			}
			
			return (delimitedData);
		}
		
		public static string ConvertCollectionToDelStr(ICollection theCollection, char delimiter)
		{
			string delimitedData = "";

			foreach (string strData in theCollection)
			{
				if (strData.Equals(delimiter.ToString()))
				{
					throw (new ArgumentException("Znak separatora nie moe wchodzi w skad elementu tablicy.", "theCollection"));
				}
				
				delimitedData += strData + delimiter;
			}

            // Zwrcenie utworzonego cigu bez kocowego znaku separatora
			return (delimitedData.TrimEnd(delimiter));
		}
        #endregion

        #region "5.14 Zapisywanie migawek list w tablicy"
        public static void TestListSnapshot()
		{
			Queue<int> someQueue = new Queue<int>();
			someQueue.Enqueue(1);
			someQueue.Enqueue(2);
			someQueue.Enqueue(3);
			
			int[] queueSnapshot = TakeSnapshotOfList<int>(someQueue);
			foreach (int i in queueSnapshot)
			{
				Console.WriteLine(i.ToString());
			}
		}
		
		public static T[] TakeSnapshotOfList<T>(ICollection theList)
		{
			T[] snapshot = new T[theList.Count]; 
			theList.CopyTo(snapshot, 0);
			return (snapshot);
		}
		#endregion

        #region "5.15 Utrzymywanie kolekcji pomidzy sesjami aplikacji"
        public static void TestSerialization()
		{
			ArrayList HT = new ArrayList();
//			HT.Add(0, "Zero");
//			HT.Add(1, "Jeden");
//			HT.Add(2, "Dwa");
			HT.Add("Zero");
			HT.Add("Jeden");
			HT.Add("Dwa");
			
//			foreach (DictionaryEntry Entry in HT)
//				Console.WriteLine(Entry.Key + " : " + Entry.Value);
			foreach (object O in HT)
				Console.WriteLine(O.ToString());
			SaveObj<ArrayList>(HT, "HT.data");
				
			ArrayList HTNew = new ArrayList();
			HTNew = RestoreObj<ArrayList>("HT.data");
//			foreach (DictionaryEntry Entry in HTNew)
//				Console.WriteLine(Entry.Key + " : " + Entry.Value);
			foreach (object O in HTNew)
				Console.WriteLine(O.ToString());
				
			if (HT == HTNew)
				Console.WriteLine("Ta sama referencja");
			else
				Console.WriteLine("Inna referencja");
				
			if (HT[0] == HTNew[0])
				Console.WriteLine("Ta sama referencja [0]");
			else
				Console.WriteLine("Inna referencja [0]");


			Console.WriteLine();
			List<int> test = new List<int>();
			test.Add(1);
			test.Add(2);
			foreach (int i in test)
				Console.WriteLine(i.ToString());
			SaveObj<List<int>>(test, "TEST.DATA");
			List<int> testNew = new List<int>();
			testNew = RestoreObj<List<int>>("TEST.DATA");
			foreach (int i in testNew)
				Console.WriteLine(i.ToString());

			Console.WriteLine();
			Dictionary<int, int> testD = new Dictionary<int, int>();
			testD.Add(1,1);
			testD.Add(2,2);
			foreach (KeyValuePair<int,int> kvp in testD)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);
			SaveObj<Dictionary<int, int>>(testD, "TEST.DATA");
			Dictionary<int, int> testDNew = new Dictionary<int, int>();
			testDNew = RestoreObj<Dictionary<int, int>>("TEST.DATA");
			foreach (KeyValuePair<int, int> kvp in testDNew)
				Console.WriteLine(kvp.Key + " : " + kvp.Value);
		}


		public static void SaveObj<T>(T obj, string dataFile)
		{
			FileStream FS = File.Create(dataFile);
			BinaryFormatter binSerializer = new BinaryFormatter();
			binSerializer.Serialize(FS, obj);
			FS.Close();
		}
		
		public static T RestoreObj<T>(string dataFile)
		{
			FileStream FS = File.OpenRead(dataFile);
			BinaryFormatter binSerializer = new BinaryFormatter();
			T obj = (T)binSerializer.Deserialize(FS);
			FS.Close();
			
			return (obj);
		}
		#endregion

        #region "5.16 Sprawdzanie wszystkich elementw tablicy Array bd List<T> "
        public static void TestArrayForNulls()
		{
            //  Utworzenie listy cigw znakw.
			List<string> strings = new List<string>();
			strings.Add("jeden");
			strings.Add(null);
			strings.Add("trzy");
			strings.Add("cztery");

            // Sprawdzenie, czy na licie nie ma wartoci null.
			string str = strings.TrueForAll(delegate(string val) 
			{
				if (val == null)
					return false;
				else
					return true;
			}).ToString();

            //  Wywietlenie wynikw.
			Console.WriteLine(str);
		}
	#endregion 

        #region "5.17 Wykonywanie operacji dla kadego elementu danych typu Array bd List<T>"
        // Klasa Data
		public class Data
		{
			public Data(int v)
			{
				val = v;
			}
			
			public int val = 0;
		}
		
		public static void TestArrayForEach()
		{
            //  Utworzenie listy obiektw typu Data.
			List<Data> numbers = new List<Data>();
			numbers.Add(new Data(1));
			numbers.Add(new Data(2));
			numbers.Add(new Data(3));
			numbers.Add(new Data(4));

            // Wywietlenie danych.
			foreach (Data d in numbers)
				Console.WriteLine(d.val);

            //  Dodanie 2 do wszystkich elementw Data.val typu integer.
			numbers.ForEach(delegate(Data obj)
			{
				obj.val += 2;
			});

            //  Wywietlenie danych
			foreach (Data d in numbers)
				Console.WriteLine(d.val);

            //  Zsumowanie wartoci val typu integer dla wszystkich obiektw Data na licie List.
			int total = 0;
			numbers.ForEach(delegate(Data obj)
			{
				total += obj.val;
			});

            // Wywietlenie sumy.
			Console.WriteLine("Suma: " + total);
		}
	#endregion 

        #region "5.18 Tworzenie obiektw tylko do odczytu typu Array lub Listr<T>"
        public static void TestReadOnlyArray()
		{
            // Utworzenie listy List i wypenienie jej cigami znakw.
			List<string> strings = new List<string>();
			strings.Add("1");
			strings.Add("2");
			strings.Add("3");
			strings.Add("4");

            // Utworzenie obiektu List z cigami znakw tylko do odczytu.
			IList<string> readOnlyStrings = strings.AsReadOnly();

            // Wywietlenie danych
			foreach (string s in readOnlyStrings)
				Console.WriteLine(s);
				
			// Ponisze operacje s niedozwolone i spowoduj zgoszenie wyjtku
			//     System.NotSupportedException: Collection is read-only.
			//readOnlyStrings.Add("NEW");
			//readOnlyStrings.Remove("1");
			//readOnlyStrings[0] = "NEW";
			
			// Jednak modyfikacja wartoci w pocztkowej tablicy jest dozwolona
			strings[0] = "jeden";
			strings[1] = null;
			
			// Dodatkowo referencja readOnlyStrings moe wskazywa na nowy obiekt List
			readOnlyStrings = new List<string>();

			// Wywietlenie danych
			foreach (string s in readOnlyStrings)
				Console.WriteLine(s);
			
		}
	#endregion
}
	
	
#region "Elementy pomocnicze receptur"	
	public class HashtableUtils
	{
		// Zwraca obiekty w postaci generycznego obiektu
		public static object[] GetKeys(Hashtable table)
		{
			ICollection hashKeys = table.Keys;

			// Dokonuje konwersji (kopiuje) interfejs ICollection na tablic obiektw
			object[] retKeys = new object[hashKeys.Count];
			hashKeys.CopyTo(retKeys, 0);

			return (retKeys);
		}

		// Zwraca wartoci w postaci generycznego obiektu
		public static object[] GetValues(Hashtable table)
		{
			ICollection HashValues = table.Values;

            // Dokonuje konwersji (kopiuje) interfejs ICollection na tablic obiektw
			object[] RetValues = new object[HashValues.Count];
			HashValues.CopyTo(RetValues, 0);

			return (RetValues);
		}

		// Zwraca indeksy w postaci cigw znakw
		public static string[] GetKeysAsStrings(Hashtable table)
		{
			ICollection hashKeys = table.Keys;

            // Dokonuje konwersji (kopiuje) interfejs ICollection na tablic cigw znakw
			string[] retKeys = new string[hashKeys.Count];
			hashKeys.CopyTo(retKeys, 0);

			return (retKeys);
		}

		// Zwraca wartoci w postaci cigw znakw
        public static string[] GetValuesAsStrings(Hashtable table)
		{
			ICollection HashValues = table.Values;

            // Dokonuje konwersji (kopiuje) interfejs ICollection na tablic cigw znakw
			string[] RetValues = new string[HashValues.Count];
			HashValues.CopyTo(RetValues, 0);

			return (RetValues);
		}

		// Mona doda inne metody zwracajce indeksy i wartoci tablic
		// Hashtable...
	}

#endregion
}
